#version 150

precision highp float;








#define hue(v)  ((.6+.6*cos(6.*(v)+vec4(0, 23, 21, 1)))+vec4(0., 0., 0., 1.) )

#define finalize() { \
    vertexDistance=length((ModelViewMat*vertex).xyz); \
    texCoord0=UV0; \
}

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;


uniform sampler2D Sampler0;

uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;

uniform float GameTime;

out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;

void f_33c52f7d(inout vec4 vertex) {
    gl_Position=ProjMat*ModelViewMat*vertex;
}

void f_a82649c3() {
    vertexColor=Color*texelFetch(Sampler2, UV2 / 16, 0);
}


void f_70a4b56b(inout vec4 vertex) {
    f_33c52f7d(vertex);
    if(Position.z==0. && gl_Position.x > .95) {
        vertexColor=vec4(0);
    }else{
        f_a82649c3();
    }
    finalize();
}



void f_813af65a() {
    vertexColor=hue(gl_Position.x+GameTime*1000.)*texelFetch(Sampler2, UV2 / 16, 0);
}

void f_92d712c2() {
    gl_Position.y+=sin(GameTime*12000.+(gl_Position.x*6)) / 150.;
}

void f_be911cee(inout vec4 vertex) {
    f_33c52f7d(vertex);
    f_813af65a();
    finalize();
}

void f_60f55b79(inout vec4 vertex) {
    f_33c52f7d(vertex);
    f_a82649c3();
    f_92d712c2();
    finalize();
}

void f_257c629d(inout vec4 vertex) {
    f_33c52f7d(vertex);
    f_92d712c2();
    f_813af65a();
    finalize();
}

void f_1ecc3378(inout vec4 vertex) {
    f_a82649c3();
    float vertexId=mod(gl_VertexID, 4.);
    if(vertex.z <= 0.) {
        if(vertexId==3. || vertexId==0.) {
            vertex.y+=cos(GameTime*12000. / 4)*.1;
            vertex.y+=max(cos(GameTime*12000. / 4)*.1, 0.);
        }
    }else{
        if(vertexId==3. || vertexId==0.) {
            vertex.y-=cos(GameTime*12000. / 4)*3;
            vertex.y-=max(cos(GameTime*12000. / 4)*4, 0.);
        }
    }
    f_33c52f7d(vertex);
    finalize();
}

void f_4d1d25c2(inout vec4 vertex) {
    float vertexId=mod(gl_VertexID, 4.);
    if(vertex.z <= 0.) {
        if(vertexId==3. || vertexId==0.) {
            vertex.y+=cos(GameTime*12000. / 4)*.1;
            vertex.y+=max(cos(GameTime*12000. / 4)*.1, 0.);
        }
    }else{
        if(vertexId==3. || vertexId==0.) {
            vertex.y-=cos(GameTime*12000. / 4)*3;
            vertex.y-=max(cos(GameTime*12000. / 4)*4, 0.);
        }
    }
    f_813af65a();
    f_33c52f7d(vertex);
    finalize();
}

void f_d5612cca(inout vec4 vertex, float speed) {
    f_33c52f7d(vertex);
    float blink=abs(sin(GameTime*12000.*speed));
    vertexColor=Color*blink*texelFetch(Sampler2, UV2 / 16, 0);
    finalize();
}



void f_6b1f248d(inout vec4 vertex) {
    f_33c52f7d(vertex);
    f_a82649c3();
    vertexColor=vec4(1, 1, 1, vertexColor.a); 
    finalize();
}


void main() {
    vec4 vertex=vec4(Position, 1.);
    ivec3 iColor=ivec3(Color.xyz*255+vec3(.5));

    
    
    if(iColor==ivec3(255, 85, 85))
    {
        f_70a4b56b(vertex);
        return;
    }
    

    
    if(fract(Position.z) < .1) {
        
        
        if(iColor==ivec3(19, 23, 9))
        {
            gl_Position=vec4(2, 2, 2, 1);
            f_a82649c3();
            finalize();
            return;
        }
        

        
        
        if(iColor==ivec3(57, 63, 63)) {
            
            
            f_33c52f7d(vertex);
            f_a82649c3();
            finalize();
            return;
        }

        
        if(iColor==ivec3(57, 63, 62)) {
            f_60f55b79(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 62, 63)) {
            
            f_60f55b79(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 62, 62)) {
            f_1ecc3378(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 61, 63)) {
            f_1ecc3378(vertex);
            return;
        }

        
        if(iColor==ivec3(57, 61, 62)) {
            f_d5612cca(vertex, .5);
            return;
        }

        

        
    }

    
    
    if(iColor==ivec3(78, 92, 36))
    {
        f_6b1f248d(vertex);
        return;
    }
    

    
    
    
    if(iColor==ivec3(230, 255, 254))
    {
        f_be911cee(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 255, 250))
    {
        f_60f55b79(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 251, 254))
    {
        f_257c629d(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 251, 250))
    {
        f_1ecc3378(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 247, 254))
    {
        f_4d1d25c2(vertex);
        return;
    }

    
    if(iColor==ivec3(230, 247, 250))
    {
        f_d5612cca(vertex, .5);
        return;
    }

    
    

    
    
    
    if(iColor==ivec3(255, 255, 254))
    {
        f_be911cee(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 253))
    {
        f_60f55b79(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 25))
    {
        f_257c629d(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 255, 251))
    {
        f_1ecc3378(vertex);
        return;
    }

    
    if(iColor==ivec3(255, 254, 254))
    {
        f_4d1d25c2(vertex);
        return;
    }
    

    
    f_33c52f7d(vertex);
    f_a82649c3();
    finalize();
}